
local assets=
{
	Asset("ANIM", "anim/knife.zip"),
	Asset("ANIM", "anim/swap_knife.zip"),
    Asset("ATLAS", "images/inventoryimages/knife.xml"),
}

local prefabs = 
{
}
local function onfinished(inst)
  inst:Remove()
end
local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_knife", "swap_knife")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 

	end


local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end
local function fn()
local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("knife")
    inst.AnimState:SetBuild("knife")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("weapon")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "knife"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/knife.xml"
     
    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
		
	inst:AddComponent("inspectable")
			
	inst:AddTag("sharp")
    inst.components.weapon:SetDamage(29)
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(32)
	inst.components.finiteuses:SetUses(32)
	inst.components.finiteuses:SetOnFinished(onfinished)
    return inst
end
return Prefab("knife", fn, assets)